<?php

namespace Ignite\Demo\Generators;

use Closure;
use Ignite\Claim\Entities\Rule;
use Ignite\Claim\Repositories\RuleRepository;
use Ignite\Demo\Generator;

class Rules
{
    /**
     * The rules to generate.
     * @var array
     */
    protected $rules = [
        ['name' => 'Base Rule'],
    ];

    /** @var RuleRepository */
    protected $ruleRepository;

    /**
     * Rules constructor.
     *
     * @param RuleRepository $ruleRepository
     */
    public function __construct(RuleRepository $ruleRepository)
    {
        $this->ruleRepository = $ruleRepository;
    }

    /**
     * Handle generation of the demo data.
     *
     * @param  Generator $generator
     * @param  Closure $next
     * @return Generator
     */
    public function handle(Generator $generator, Closure $next)
    {
        foreach ($this->rules as $rule) {
            try {
                $this->createRule($rule);
            } catch (\Exception $e) {
                $generator->addError($this, $e);
                return $generator;
            }
        }

        return $next($generator);
    }

    /**
     * Create a rule record.
     *
     * @param  array $rule
     * @return array
     * @throws \Exception
     */
    protected function createRule(array $rule)
    {
        $data = $this->getRuleData($rule);
        $data['class'] = 'claim_rule';
        $data['action'] = 'createRule';
        $response = $this->ruleRepository->put($data);

        if (! $response->result) {
            throw new \Exception(implode('; ', $response->errors));
        }

        return $response;
    }

    /**
     * Get the necessary rule data.
     *
     * @param  array $rule
     * @return array
     */
    protected function getRuleData($rule)
    {
        return [
            'name' => $rule['name'],
            'order' => 1,
            'status' => 1,
            'offer_promotion_id' => 1,
            'start_date' => now()->subMonth(2)->startOfMonth(),
            'end_date' => now()->addMonth()->endOfMonth(),
            'participants_mode_id' => Rule::PARTICIPANT_MODE_ALL,
            'offers_mode_id' => Rule::OFFER_MODE_ALL,
            'value_mode_id' => Rule::VALUE_SOURCE_OFFER,
            'offers' => [],
            'values' => [],
            'conditions' => [],
            'participants' => [],
        ];
    }

    /**
     * Get the identifier for the record.
     *
     * @param  array $rule
     * @return string
     */
    protected function getIdentifier($rule)
    {
        return $rule['name'];
    }
}
