<?php

namespace Ignite\Demo\Generators;

use Closure;
use Ignite\Claim\Entities\Offer;
use Ignite\Claim\Repositories\OfferRepository;
use Ignite\Demo\Generator;

class Offers
{
    /**
     * The offers to generate.
     * @var array
     */
    protected $offers = [
        ['name' => 'Deal Registration', 'group' => 'Cenergy PBX'],
        ['name' => 'Sold Deal', 'group' => 'Cenergy PBX'],
        ['name' => 'Deal Registration', 'group' => 'Cenergy Networking'],
        ['name' => 'Sold Deal', 'group' => 'Cenergy Networking'],
    ];

    /** @var OfferRepository */
    protected $offerRepository;

    /**
     * Offers constructor.
     *
     * @param OfferRepository $offerRepository
     */
    public function __construct(OfferRepository $offerRepository)
    {
        $this->offerRepository = $offerRepository;
    }

    /**
     * Handle generation of the demo data.
     *
     * @param  Generator $generator
     * @param  Closure $next
     * @return Generator
     */
    public function handle(Generator $generator, Closure $next)
    {
        foreach ($this->offers as $offer) {
            try {
                $this->createOffer($offer);
            } catch (\Exception $e) {
                $generator->addError($this, $e);
                return $generator;
            }
        }

        return $next($generator);
    }

    /**
     * Create an offer record.
     *
     * @param  array $offer
     * @return array
     * @throws \Exception
     */
    protected function createOffer(array $offer)
    {
        $data = $this->getOfferData($offer);
        $data['class'] = 'claim_offer';
        $data['action'] = 'createOffer';
        $response = $this->offerRepository->put($data);

        if (! $response->result) {
            throw new \Exception(implode('; ', $response->errors));
        }

        return $response;
    }

    /**
     * Get the necessary offer data.
     *
     * @param  array $offer
     * @return array
     */
    protected function getOfferData($offer)
    {
        return [
            'name' => $offer['name'],
            'sku' => $this->getIdentifier($offer),
            'offer_group' => $offer['group'],
            'active' => 1,
            'promotion_id' => 1,
            'value_mode_id' => Offer::VALUE_MODE_MULTIPLE,
            'value_type_id' => Offer::VALUE_TYPE_FIXED,
            'values' => [
                [
                    'participant_type' => 'Account Executive',
                    'value_type_id' => Offer::VALUE_TYPE_FIXED,
                    'value' => 50
                ], [
                    'participant_type' => 'Sales Engineer',
                    'value_type_id' => Offer::VALUE_TYPE_FIXED,
                    'value' => 100
                ]
            ]
        ];
    }

    /**
     * Get the identifier for the record.
     *
     * @param $offer
     * @return string
     */
    protected function getIdentifier($offer)
    {
        return str_slug($offer['name']);
    }
}
