<?php

namespace Ignite\Demo\Generators;

use Closure;
use Illuminate\Support\Collection;
use Ignite\Claim\Repositories\ClaimRepository;
use Ignite\Claim\Entities\Offer;
use Ignite\Core\Entities\Participant;
use Ignite\Demo\Generator;

class Claims
{
    /**
     * The claims to generate.
     * @var array
     */
    protected $claims = [
        [
            'customer_name' => 'Test',
            'prm_number' => '12345',
            'distributor_po_number' => '54321'
        ], [
            'customer_name' => 'Test',
            'prm_number' => '12345',
            'distributor_po_number' => '54321'
        ], [
            'customer_name' => 'Test',
            'prm_number' => '12345',
            'distributor_po_number' => '54321'
        ]
    ];

    /** @var ClaimRepository */
    protected $claimRepository;

    /**
     * claims constructor.
     *
     * @param ClaimRepository $claimRepository
     */
    public function __construct(ClaimRepository $claimRepository)
    {
        $this->claimRepository = $claimRepository;
    }

    /**
     * Handle generation of the demo data.
     *
     * @param  Generator $generator
     * @param  Closure $next
     * @return Generator
     */
    public function handle(Generator $generator, Closure $next)
    {
        $participants = Participant::all();
        $offers = Offer::where('promotion_id', 1)->get();

        try {
            foreach ($participants as $participant) {
                $this->createClaimsForParticipant($participant, $offers);
            }
        } catch (\Exception $e) {
            $generator->addError($this, $e);
            return $generator;
        }

        return $next($generator);
    }

    /**
     * Create claims for participant.
     *
     * @param  Participant $participant
     * @param  Collection $offers
     * @throws \Exception
     */
    protected function createClaimsForParticipant(Participant $participant, Collection $offers)
    {
        auth()->login($participant->user);
        app('authorization')->forgetPermissions()->registerPermissions();

        foreach ($this->claims as $claim) {
            $data = $this->getClaimData($claim);
            $data['class'] = 'claim';
            $data['action'] = 'createClaim';
            $data['claim_items'] = $offers->map(function ($offer) {
                return [
                    'id' => 'new',
                    'offer_id' => $offer->id,
                    'name' => $offer->name,
                    'offer_group' => $offer->offer_group,
                    'qty' => 1,
                    'status' => 1,
                ];
            })->filter()->toArray();
            $data['claim_participants'] = [];
            $data['offer_promotion_id'] = 1;
            $data['upload_files'] = [];

            $response = $this->claimRepository->put($data);

            if (! $response->result) {
                throw new \Exception(implode('; ', $response->errors));
            }
        }
    }

    /**
     * Get the necessary claim data.
     *
     * @param  array $claim
     * @return array
     */
    protected function getClaimData($claim)
    {
        return [
            'customer_name' => $claim['customer_name'],
            'prm_number' => $claim['prm_number'],
            'activity_date' => now()->subDays(rand(1, 30))->format('Y-m-d H:i:s'),
            'distributor_po_number' => $claim['distributor_po_number'],
            'sale_value' => rand(100, 1000),
        ];
    }
}
