<?php

namespace Ignite\Demo;

use Illuminate\Pipeline\Pipeline;
use Illuminate\Support\MessageBag;

/**
 * Class Generator
 *
 * @method Generator then(\Closure $destination)
 */
class Generator
{
    /** @var MessageBag */
    private $errors;

    /**
     * The handlers to be run in order of FIFO.
     * @var array
     */
    protected $handlers = [
        \Ignite\Demo\Generators\Participants::class,
    ];

    public function __construct()
    {
        $this->errors = new MessageBag();
    }

    /**
     * Run the generator.
     *
     * @param  bool $installClaimData
     * @param  bool $installOrderData
     * @return $this
     */
    public function run($installClaimData = false, $installOrderData = false)
    {
        if ($installClaimData) {
            $this->handlers[] = \Ignite\Demo\Generators\Settings::class;
            $this->handlers[] = \Ignite\Demo\Generators\Offers::class;
            $this->handlers[] = \Ignite\Demo\Generators\Rules::class;
            $this->handlers[] = \Ignite\Demo\Generators\Claims::class;
        }

        if ($installOrderData) {
            $this->handlers[] = \Ignite\Demo\Generators\Orders::class;
        }

        return app()->make(Pipeline::class)
            ->send($this)
            ->through($this->handlers);
    }

    /**
     * Get any errors which occurred during the generation process.
     *
     * @return MessageBag
     */
    public function errors()
    {
        return $this->errors;
    }

    /**
     * Add an error message.
     *
     * @param  $class
     * @param  $error
     * @return $this
     */
    public function addError($class, $error)
    {
        if (is_object($class)) {
            $class = get_class($class);
        }

        if (is_array($error)) {
            $error = array_merge($this->errors->get('class'), $error);
        }

        if ($error instanceof \Exception) {
            $error = sprintf(
                "%s - Code: %s - Line: %s - File: %s",
                $error->getMessage(),
                $error->getCode(),
                $error->getLine(),
                $error->getFile()
            );
        }

        $this->errors->add($class, $error);

        return $this;
    }
}
