<?php

namespace Ignite\Demo\Generators;

use Closure;
use Ignite\Demo\Generator;
use Ignite\Claim\Entities\Setting;

class Settings
{
    /**
     * The settings to update.
     * @var array
     */
    protected $settings = [
        'claim.document.requires' => "Invoice:0:1\r\nPurchase Order:0:0\r\nOther:0:0",
        'form.claim.partial.claim_fields_external' => "{\"module\":\"claim\",\"type\":\"partial\",\"name\":\"claim_new_partial\",\"columns\":{\"claim\":{\"customer_name\":{\"order\":\"1\",\"table\":\"claim\",\"name\":\"customer_name\",\"displayName\":\"Customer Name\",\"type\":\"text\",\"required\":\"1\",\"validateType\":null,\"validate\":null,\"format\":null},\"activity_date\":{\"order\":\"2\",\"table\":\"claim\",\"name\":\"activity_date\",\"displayName\":\"Date Sold\",\"type\":\"date\",\"required\":\"1\",\"validateType\":\"date\",\"validate\":null,\"format\":null},\"sale_value\":{\"order\":\"3\",\"table\":\"claim\",\"name\":\"sale_value\",\"displayName\":\"Amount of Deal\",\"type\":\"text\",\"required\":\"1\",\"validateType\":\"float\",\"validate\":null,\"format\":null},\"prm_number\":{\"order\":\"4\",\"table\":\"claim\",\"name\":\"prm_number\",\"displayName\":\"Opportunity #\",\"type\":\"text\",\"required\":\"1\",\"validateType\":\"none\",\"validate\":null,\"format\":null},\"distributor_po_number\":{\"order\":\"5\",\"table\":\"claim\",\"name\":\"distributor_po_number\",\"displayName\":\"PO#\",\"type\":\"text\",\"required\":\"1\",\"validateType\":\"none\",\"validate\":null,\"format\":null}}}}"
    ];

    /**
     * Handle generation of the demo data.
     *
     * @param  Generator $generator
     * @param  Closure $next
     * @return Generator
     */
    public function handle(Generator $generator, Closure $next)
    {
        try {
            foreach ($this->settings as $key => $value) {
                Setting::where('key', $key)->update(['value' => $value]);
            }
        } catch (\Exception $e) {
            $generator->addError($this, $e);
        }

        return $next($generator);
    }
}
