<?php

namespace Ignite\Course\Models\Report;

use Ignite\Core\Entities\Filters\QueryPermissionFilters;
use Ignite\Core\Entities\User;
use Ignite\Core\Models\Grid\QueryTable;

class CourseCompletionsReport extends QueryTable
{
    /**
     * The columns to show.
     *
     * @return array
     */
    public function columns()
    {
        $type = config('course.default_type');
        $columns = [
            'created_at' => [
                'title' => 'Completed Date',
                'name' => 'activity_course_completion.created_at',
            ],
            'first' => [
                'title' => 'First',
                'name' => 'participant.first',
            ],
            'last' => [
                'title' => 'Last',
                'name' => 'participant.last',
            ],
            'email' => [
                'title' => 'Email',
                'name' => 'participant.email',
            ],
            'course_name' => [
                'title' => __("Course::types.{$type}.Course"),
                'name' => 'activity_course_completion.course_name',
            ],
            'family' => [
                'title' => __("Course::types.{$type}.Course Family"),
                'name' => 'activity_course_family.name as family',
            ],
            'locale' => [
                'title' => 'Language',
                'name' => 'activity_course_completion.locale',
            ],
            'category' => [
                'title' => 'Category',
                'name' => 'activity_course_family.category',
            ],
            'score' => [
                'title' => 'Score',
                'name' => 'activity_course_completion.score',
            ],
            'value' => [
                'title' => 'Points',
                'name' => 'activity_submission.value',
            ],
        ];

        foreach ($columns as $column => $value) {
            $columns[$column]['visible'] = true;
            $columns[$column]['orderable'] = true;
            $columns[$column]['exportable'] = true;
            $columns[$column]['searchable'] = true;
        }

        return $columns;
    }

    /**
     * The report query.
     *
     * @return \Illuminate\Database\Query\Builder
     */
    public function query()
    {
        $columns = $this->getColumnNames([])->toArray();

        $query = $this->getConnection()
            ->table('activity_course_completion')
            ->select($columns)
            ->leftJoin(
                'activity_course_family',
                'activity_course_completion.activity_course_family_id',
                '=',
                'activity_course_family.id'
            )
            ->leftJoin('activity', 'activity_course_completion.activity_id', '=', 'activity.id')
            ->leftJoin('activity_submission', 'activity_submission.activity_id', '=', 'activity.id')
            ->leftJoin('core_user as user', 'activity_submission.user_id', '=', 'user.user_id')
            ->leftJoin('core_participant as participant', 'user.user_id', '=', 'participant.user_id')
            ->where('user.internal', User::TYPE_PARTICIPANT);

        return QueryPermissionFilters::for('core.user.participant.browse')
            ->apply($query, 'participant');
    }

    /**
     * Get a map of column keys => functions to format columns.
     *
     * @return array
     */
    protected function getColumnFormattingMap()
    {
        return [
            'locale' => function ($model) {
                return strtoupper($model->locale);
            },
        ];
    }
}
