<?php

namespace Ignite\Course\Database\Seeders;

use Ignite\Course\Database\Seeders\CourseGroupPermissionTableSeeder;
use Ignite\Course\Database\Seeders\CoursePermissionTableSeeder;
use Ignite\Course\Database\Seeders\CourseTypeSeeder;
use Ignite\Course\Database\Seeders\ReportTableSeeder;
use Illuminate\Database\Seeder;

/**
 * Should be called by RunCourseSeeder through `php artisan db:seed`.
 *
 * If needed manually:
 * php artisan db:seed --class="Ignite\Course\Database\Seeders\CourseSeeder"
 */
class CourseSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $this->call(CoursePermissionTableSeeder::class);
        $this->call(CourseGroupPermissionTableSeeder::class);
        $this->call(CourseTypeSeeder::class);
        $this->call(ReportTableSeeder::class);
        $this->call(CourseListSeeder::class);

        // echo "Package [Course] seeded." . PHP_EOL;
    }
}
