<?php

namespace Ignite\Course\Database\Seeders;

use Ignite\Core\Database\Seeders\AbstractSeeder;
use Ignite\Core\Entities\Permission;
use Ignite\Course\Database\Seeders\Traits\CourseSeederPath;

class CoursePermissionTableSeeder extends AbstractSeeder
{
    use CourseSeederPath;

    /**
     * The path to the data file.
     *
     * @var string
     */
    protected $file = 'course_permission.json';

    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        parent::run();

        $strategy = $this->strategy('json', [
            'filepath' => $this->getFilepath($this->file)
        ]);

        $sources = $strategy->run();

        app('authorization')->forgetCachedPermissions();

        foreach ($sources as $source) {
            try {
                Permission::updateOrCreate(['key' => $source['key']], $source);
            } catch (\Exception $e) {
                echo $e->getMessage() . PHP_EOL;
                continue;
            }
        }
    }
}
