<div class="col-md-8 mt-4 pt-1">
    <table id="courseCompletionsTable" class="table table-striped">
        <thead>
            <tr>
                <th>{{ __("Course::types.{$type->code}.labels.date") }}</th>
                <th>{{ __("Course::types.{$type->code}.labels.category") }}</th>
                <th class="hidden-xs">{{ __("Course::types.{$type->code}.labels.description") }}</th>
                @if (config("course.pages.course_completed.show_points"))
                <th class="text-right">{{ trans_choice('Core::core.common.points', 2) }}</th>
                @endif
            </tr>
        </thead>
        <tbody>
        @forelse($submissions as $submission)
            <tr>
                <td>{{ $submission->created_at->format(config('course.pages.course_completed.completed_datetime_format')) }}</td>
                <td>{{ $submission->activity->data->courseFamily->category ?? 'N/A' }}</td>
                <td><span bablic-exclude>{{ $submission->activity->data->course_name ?? ($submission->activity->data->course->name ?? 'N/A') }}</span></td>
                @if (config("course.pages.course_completed.show_points"))
                <td class="text-right">{{ Format::amount($submission->value) }}</td>
                @endif
            </tr>
        @empty
            <tr>
                @php
                $colspan = 3;
                if (config("course.pages.course_completed.show_points")) {
                    $colspan++;
                }
                @endphp
                <td colspan="{{ $colspan }}" class="text-danger text-center">{{ __("Course::types.{$type->code}.labels.no_completions_found") }}</td>
            </tr>
        @endforelse
        </tbody>
    </table>
</div>

@push('styles')
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.19/css/dataTables.bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/rowgroup/1.1.0/css/rowGroup.bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.3.1/css/buttons.bootstrap.min.css">
    <style type="text/css">
    #courseCompletionsTable_wrapper .dataTables_length {
        float: right !important;
        text-align: right !important;
        margin-right: 0 !important;
    }
    </style>
@endpush

@push('scripts')
    <script type="text/javascript" src="https://cdn.datatables.net/1.10.19/js/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/1.10.19/js/dataTables.bootstrap.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/rowgroup/1.1.0/js/dataTables.rowGroup.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.5.4/js/dataTables.buttons.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.5.2/js/buttons.html5.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.5.2/js/buttons.colVis.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.5.2/js/buttons.print.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.5.4/js/buttons.bootstrap.min.js"></script>
    <script type="text/javascript" src="//cdnjs.cloudflare.com/ajax/libs/moment.js/2.8.4/moment.min.js"></script>
    <script type="text/javascript" src="//cdn.datatables.net/plug-ins/1.11.4/sorting/datetime-moment.js"></script>
    <script type="text/javascript">
        $.fn.dataTable.moment('d/m/YYYY');
        $.extend($.fn.dataTableExt.oStdClasses, {
            "sFilterInput": "dataTables_filter form-control",
            "sLengthSelect": "dataTables_length form-control"
        });
        let coursesDataTable = $('#courseCompletionsTable').DataTable({
            order: [[1, 'desc']],
            dom: '<"row"<"col-md-6 text-left"f><"col-md-6 text-right"l<"mr-1 pull-right"B>>><"panel mt-2 mb-1"<"panel-body"<"negative-margin table-responsive"t>>><"row"<"col-md-6"i><"col-md-6"p>>',
            responsive: true,
            autoWidth: false,
            language: {
                search: '',
                searchPlaceholder: "{{ __("Course::types.{$type->code}.labels.dt_searchPlaceholder") }}",
                lengthMenu: '_MENU_'
            },
            buttons: ['csv']
        });
    </script>
@endpush
