@push('js')
@php
$max = 0;
if ($form->getField('upload')) {
    // get max file size from $form upload field
    $rules = $form->getField('upload')->getOption('rules');
    $max = collect($rules)->filter(function ($rule) {
        return Str::startsWith($rule, 'max:');
    })->map(function ($rule) {
        return Str::after($rule, 'max:');
    })->first();
}
@endphp
<script type="text/javascript">
    function checkFileSize(event) {
        var maxsize = {{ $max }};
        var input = document.getElementById('upload');
        if (!input) {
            return;
        }

        var file = input.files[0];
        if (file && file.size > maxsize) {
            event.preventDefault();
            event.stopPropagation();

            maxInMb = Math.round(maxsize / 1024 / 1024);
            sizeInMb = Math.round(file.size / 1024 / 1024);
            alert("File size is too large at " + sizeInMb + " MB. Maximum file size needs to be less than " + maxInMb + " MB.");
            event.preventDefault();
            event.stopPropagation();
        }
    }

    document.getElementById("submit-course").addEventListener("click", checkFileSize);
</script>
@endpush
