<?php

namespace Ignite\Course\Domain\Activity\Rules;

use Ignite\Activity\Domain\Rules\Base;
use Ignite\Activity\Domain\Rules\ChangesValue;
use Ignite\Activity\Domain\Rules\RuleManager;

class Simple extends Base implements ChangesValue
{
    /**
     * The value of the claim.
     *
     * @var int|float
     */
    protected $value = 0;

    /**
     * Apply the Rule logic to the given submission.
     *
     * @param RuleManager $manager
     *
     * @return bool
     */
    public function apply(RuleManager $manager)
    {
        $this->value = $manager->value();

        $activity = $manager->getActivity();

        // use the points assigned by the course
        if ($activity->data->courseFamily->points) {
            $this->value = $activity->data->courseFamily->points;
            $this->addInfoMessage(sprintf(
                'Earned %s points.',
                $this->value
            ));

            return true;
        }

        // $this->addErrorMessage(
        //     sprintf('Rule %s not applied.', $this->rule->name)
        // );

        return false;
    }

    /**
     * The changed value.
     *
     * @return float|int
     */
    public function getChangedValue()
    {
        return $this->value;
    }
}
