<?php

namespace Ignite\Course\Database\Seeders;

use Ignite\Activity\Database\Seeders\Seeder as ActivitySeeders;
use Ignite\Course\Database\Seeders\Traits\CourseSeederPath;

/**
 * php artisan db:seed --class="Ignite\Program\Database\Seeders\CourseTypeSeeder"
 */
class CourseTypeSeeder extends ActivitySeeders
{
    use CourseSeederPath;

    /**
     * The path to the data file.
     *
     * @var string
     */
    protected $file = 'course_type.json';

    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $strategy = $this->strategy('json', [
            'filepath' => $this->getFilepath($this->file)
        ]);

        $sources = $strategy->run();

        foreach ($sources as $source) {
            $this->seed($source);
        }
    }
}
