<?php

use Ignite\Course\Http\Controllers\Admin\CourseController as AdminCourseController;
use Ignite\Course\Http\Controllers\Admin\CourseFamilyController as AdminCourseFamilyController;
use Ignite\Course\Http\Controllers\CourseController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::group(
    [
        'middleware' => ['auth'],
        'prefix' => config('course.default_type'),
    ],
    function () {
        Route::get("/index/{category?}", [CourseController::class, 'index'])
            ->name('activity.course.index')
            ->middleware('can:activity.browse');
        Route::get('/completed', [CourseController::class, 'completed'])
            ->name('activity.course.completed')
            ->middleware('can:activity.browse');
        Route::get("/start/{course:code}", [CourseController::class, 'start'])
            ->name('activity.course.start')
            ->middleware('can:activity.browse');
        Route::post("/complete", [CourseController::class, 'complete'])
            ->name('activity.course.complete')
            // Make sure /course/complete does not use VerifyCsrfToken so the course JS can post to this
            ->withoutMiddleware(\App\Http\Middleware\VerifyCsrfToken::class)
            ->middleware('can:activity.browse');
        Route::get("/end", [CourseController::class, 'end'])
            ->name('activity.course.end')
            ->middleware('can:activity.browse');
        Route::get("/exit", [CourseController::class, 'exit'])
            ->name('activity.course.exit')
            ->middleware('can:activity.browse');
    }
);

/* Admin Pages Routes
 * -------------------------------------------------- */
Route::group(
    [
        'prefix' => '/admin/' . config('course.default_type'),
        'namespace' => 'Admin',
        'middleware' => ['web', 'auth'],
    ],
    function () {
        Route::any('family/index/{type:code}', [AdminCourseFamilyController::class, 'index'])
            ->middleware("can:course.all.browse")
            ->name("admin.course_family.index");
        Route::get('family/show/{type:code}/{courseFamily}', [AdminCourseFamilyController::class, 'show'])
            ->middleware("can:course.all.view")
            ->name("admin.course_family.show");
        Route::any('family/history/{type:code}/{courseFamily}', [AdminCourseFamilyController::class, 'history'])
            ->middleware("can:course.all.view")
            ->name("admin.course_family.history");
        Route::get('family/create/{type:code}', [AdminCourseFamilyController::class, 'create'])
            ->middleware("can:course.all.create")
            ->name("admin.course_family.create");
        Route::post('family/store/{type:code}', [AdminCourseFamilyController::class, 'store'])
            ->middleware("can:course.all.create")
            ->name("admin.course_family.store");
        Route::get('family/edit/{type:code}/{courseFamily}', [AdminCourseFamilyController::class, 'edit'])
            ->middleware("can:course.all.update")
            ->name("admin.course_family.edit");
        Route::post('family/update/{type:code}/{courseFamily}', [AdminCourseFamilyController::class, 'update'])
            ->middleware("can:course.all.update")
            ->name("admin.course_family.update");

        Route::any('index/{type:code}/{courseFamily}', [AdminCourseController::class, 'index'])
            ->middleware("can:course.all.browse")
            ->name("admin.course.index");
        Route::get('/show/{type:code}/{course}', [AdminCourseController::class, 'show'])
            ->middleware("can:course.all.view")
            ->name("admin.course.show");
        Route::any('/history/{type:code}/{course}', [AdminCourseController::class, 'history'])
            ->middleware("can:course.all.view")
            ->name("admin.course.history");
        Route::get('/create/{type:code}/{courseFamily}', [AdminCourseController::class, 'create'])
            ->middleware("can:course.all.create")
            ->name("admin.course.create");
        Route::post('/store/{type:code}/{courseFamily}', [AdminCourseController::class, 'store'])
            ->middleware("can:course.all.create")
            ->name("admin.course.store");
        Route::get('/edit/{type:code}/{course}', [AdminCourseController::class, 'edit'])
            ->middleware("can:course.all.update")
            ->name("admin.course.edit");
        Route::post('/update/{type:code}/{course}', [AdminCourseController::class, 'update'])
            ->middleware("can:course.all.update")
            ->name("admin.course.update");
    }
);
