<?php

namespace Ignite\Course\Database\Seeders\Traits;

trait CourseSeederPath
{
    /**
     * Customize the filepath.
     *
     * @param  string $filename
     * @return bool|string
     */
    protected function getFilepath($filename)
    {
        if (! empty($this->path)) {
            // if path is explicitly set
            return $this->path . $filename;
        } elseif (! empty(config('core.seeder.path'))) {
            // if path is configured and not null
            $path = realpath(base_path(config('core.seeder.path') . '/' . $filename));
            if (false !== $path) {
                return $path;
            }
        }

        // use the Course/database/data path
        return realpath(__DIR__ . '/../../../../database/data/' . $filename);
    }
}
