<?php

namespace Ignite\Course\Contracts;

use Ignite\Activity\Entities\Submission;
use Ignite\Activity\Events\ActivitySubmissionStatusChanged;
use Ignite\Core\Entities\Transaction;
use Ignite\Core\Entities\User;
use Ignite\Course\Entities\Course;
use Illuminate\Support\Collection;

interface CourseRepositoryInterface
{
    /**
     * @return string
     */
    public static function getBablicLocale(): string;

    /**
     * @return string
     */
    public static function getCoursePathBase(): string;

    /**
     * @param Course $course
     * @return string
     */
    public static function getCourseUrl(Course $course): string;

    /**
     * @return string
     */
    public static function getCourseUrlBase(): string;

    /**
     * @return array
     */
    public static function getLocalePreferences(string $type): array;

    /**
     * @param Course $course
     */
    public static function gotoCourse(Course $course);

    /**
     * @param Collection $courses
     * @param string     $type
     * @return Collection
     */
    public static function sortCourseCollection(Collection $courses, string $type): Collection;

    /**
     * @param User        $user
     * @param Course      $course
     * @param string|null $status
     * @param int|null    $score
     * @return self
     */
    public function completeCourse(User $user, Course $course, string $status = null, int $score = null): self;

    /**
     * Creates a transaction from a course completion.
     *
     * @param  Submission $submission
     * @return Transaction
     */
    public function createTransactionFromCourseCompletion(Submission $submission): Transaction;

    /**
     * @return bool
     */
    public function getPreviousPassedStatus(): bool;

    /**
     * @return bool
     */
    public function getRecentPassedStatus(): bool;

    /**
     * @param User   $user
     * @param Course $course
     * @return self
     */
    public function loadPassedStatus(User $user, Course $course): self;

    /**
     * @param string     $name
     * @param array|null $parameters
     * @param bool       $absolute
     */
    public function route(string $name, $parameters = [], bool $absolute = true);

    /**
     * @param User        $user
     * @param Course      $course
     * @param string|null $status
     * @param int|null    $score
     */
    public function setRecentCompletedCourse(
        User $user,
        Course $course,
        string $status = null,
        int $score = null
    ): void;

    /**
     * @param User   $user
     * @param Course $course
     * @return self
     */
    public function startCourse(User $user, Course $course): self;

    /**
     * On status change, create points.
     *
     * @param  ActivitySubmissionStatusChanged $event
     * @return void
     */
    public function statusChanged(ActivitySubmissionStatusChanged $event): void;
}
