<?php

use Ignite\Course\Domain\Activity\CourseStrategy;
use Ignite\Course\Entities\Course;
use Ignite\Course\Entities\CourseCompletion;
use Ignite\Course\Entities\CourseFamily;
use Ignite\Course\Models\Options\CourseCategories;
use Ignite\Course\Models\Options\CourseLocales;
use Ignite\Course\Models\Options\CourseStatuses;

// $parent = include base_path('vendor/ignite/course/config/course.php');
// return array_replace_recursive($parent, [/* custom configs */]);

return [
    'name' => 'Course',
    // if use_default_migration is true, the migration will use the default migration files
    // if it is false, then you should vendor:publish the migration files and change it as needed
    'use_default_migration' => true,
    'default_type' => 'course',
    'nav_menu_position' => 20,
    'user_menu_position' => 30,
    'admin_menu_position' => 30,
    'source' => [
        'models' => [
            'course_categories' => CourseCategories::class,
            'course_locales' => CourseLocales::class,
            'course_statuses' => CourseStatuses::class,
        ],
    ],
    'pages' => [
        'course_index' => [
            'show_points' => true,
            // on the /course/index page, should it show "see more languages"
            // if the course is available in languages other than the current one?
            'show_more_languages' => [
                // if you have Bablic on the site, then you could make this false,
                // and use Bablic to see the other languages for the course.
                'bablic_on' => false,
                // if you do not have Bablic on the site, then it is recommended
                // to set this to true so you can show other options.
                'bablic_off' => true,
            ],
        ],
        'course_completed' => [
            'show_points' => true,
            'completed_datetime_format' => 'Y-m-d', // 'Y-m-d 00:00:00P'
            // on the /course/completed, do we want to use the legacy datatables
            // similar to the /participant/activity and /transactions pages?
            // Or do we want to use the new datatable format, with more exports
            // and in a panel?
            'use_legacy_datatables' => true,
        ],
    ],
    // @todo: we can have multiple instances of a 'course' activity type...
    // but right now, it only fully supports one.
    // @note: you can use different offers for courses instead of actual
    // different types, if the course structure are similar.
    'types' => [
        // you can have multiple types that are "courses" if needed
        // each with different tables/models
        'course' => [
            'course_family_table' => 'activity_course_family',
            'course_table' => 'activity_course',
            'completion_table' => 'activity_course_completion',
            'course_family_model' => CourseFamily::class,
            'course_model' => Course::class,
            'completion_model' => CourseCompletion::class,
            // should implement Ignite\Activity\Contracts\TypeStrategyInterface
            'activityTypeStrategy' => CourseStrategy::class,
            'hideEmptyCategories' => true,

            // the locales may be displayed in the order listed here
            'locales' => [
                'en' => 'English',
                'fr' => 'French',
                // 'fr_ca' => 'French CA',
            ],
            // the categories will be displayed in the order listed here
            'categories' => [
                // 'Default' => 'All',
            ],
            'category_images' => [
                // 'Default' => 'image.jpg',
            ],
            'statuses' => [
                'pending' => [
                    'name' => 'Pending',
                    'type' => 'initial',
                    'color' => 'yellow',
                    'icon' => 'question'
                ],
                'inactive' => [
                    'name' => 'Inactive',
                    'type' => 'final',
                    'color' => 'red',
                    'icon' => 'ban'
                ],
                'active' => [
                    'name' => 'Active',
                    'type' => 'final',
                    'color' => 'green',
                    'icon' => 'check'
                ],
            ],
            'submission_default_status' => 'approved',
            'course_family_fields' => [
                'id' => [
                    'name' => 'id',
                    'table' => 'activity_course_family',
                    'frontend_type' => 'hidden',
                    'backend_type' => 'string',
                    'title' => 'ID',
                    'label' => 'ID',
                    'label_alias' => 'ID',
                    'label_show' => false,
                    'searchable' => false,
                    'exportable' => false,
                    'visible' => false,
                ],
                'name' => [
                    'name' => 'name',
                    'table' => 'activity_course_family',
                    'frontend_type' => 'text',
                    'backend_type' => 'string',
                    'title' => 'Family',
                    'label' => 'Family',
                    'label_alias' => 'Family',
                    'label_show' => true,
                    'searchable' => true,
                    'exportable' => true,
                    'visible' => true,
                    'rules' => ['required'],
                ],
                'category' => [
                    'name' => 'category',
                    'table' => 'activity_course_family',
                    'frontend_type' => 'select',
                    'backend_type' => 'string',
                    'title' => 'Category',
                    'label' => 'Category',
                    'label_alias' => 'Category',
                    'label_show' => true,
                    'searchable' => true,
                    'exportable' => true,
                    'visible' => true,
                    'rules' => [],
                    'choices' => '{course_categories}',
                    'selected' => '',
                    'empty_value' => '--- select ---',
                ],
                'passing_score' => [
                    'name' => 'passing_score',
                    'table' => 'activity_course_family',
                    'frontend_type' => 'number',
                    'backend_type' => 'string',
                    'title' => 'Passing Score',
                    'label' => 'Passing Score',
                    'label_alias' => 'Passing Score',
                    'label_show' => true,
                    'searchable' => true,
                    'exportable' => true,
                    'visible' => true,
                    'rules' => ['nullable', 'numeric'],
                ],
                'points' => [
                    'name' => 'points',
                    'table' => 'activity_course_family',
                    'frontend_type' => 'number',
                    'backend_type' => 'string',
                    'title' => 'Points',
                    'label' => 'Points',
                    'label_alias' => 'Points',
                    'label_show' => true,
                    'searchable' => true,
                    'exportable' => true,
                    'visible' => true,
                    'rules' => ['nullable', 'numeric'],
                ],
                'notes' => [
                    'name' => 'notes',
                    'table' => 'activity_course_family',
                    'frontend_type' => 'textarea',
                    'backend_type' => 'textarea',
                    'title' => 'Internal Notes',
                    'label' => 'Internal Notes',
                    'label_alias' => 'Notes',
                    'label_show' => true,
                    'searchable' => true,
                    'exportable' => true,
                    'visible' => true,
                    'rules' => [],
                ],
                'publish_start' => [
                    'name' => 'publish_start',
                    'table' => 'activity_course_family',
                    'frontend_type' => 'date',
                    'backend_type' => 'date',
                    'title' => 'Publish Start',
                    'label' => 'Publish Start',
                    'label_alias' => 'Start',
                    'label_show' => true,
                    'searchable' => true,
                    'exportable' => true,
                    'visible' => true,
                    'rules' => [],
                ],
                'publish_end' => [
                    'name' => 'publish_end',
                    'table' => 'activity_course_family',
                    'frontend_type' => 'date',
                    'backend_type' => 'date',
                    'title' => 'Publish End',
                    'label' => 'Publish End',
                    'label_alias' => 'End',
                    'label_show' => true,
                    'searchable' => true,
                    'exportable' => true,
                    'visible' => true,
                    'rules' => [],
                ],
                'num_active' => [
                    'name' => 'num_active',
                    'table' => 'activity_course_family',
                    'frontend_type' => 'number',
                    'backend_type' => 'string',
                    'title' => '# Active',
                    'label' => '# Active',
                    'label_alias' => '# Active',
                    'label_show' => true,
                    'searchable' => false,
                    'exportable' => true,
                    'visible' => true,
                    'rules' => [],
                    'attr' => ['readonly' => true],
                ],
                'sequence' => [
                    'name' => 'sequence',
                    'table' => 'activity_course_family',
                    'frontend_type' => 'number',
                    'backend_type' => 'string',
                    'title' => 'Sequence',
                    'label' => 'Sequence',
                    'label_alias' => 'Sequence',
                    'label_show' => true,
                    'searchable' => false,
                    'exportable' => true,
                    'visible' => true,
                    'rules' => [],
                ],
                'created_at' => [
                    'name' => 'created_at',
                    'table' => 'activity_course_family',
                    'frontend_type' => 'text',
                    'backend_type' => 'datetime',
                    'title' => 'Created At',
                    'label' => 'Created At',
                    'label_alias' => 'Created At',
                    'label_show' => true,
                    'searchable' => true,
                    'exportable' => true,
                    'visible' => true,
                    'rules' => [],
                    'attr' => [
                        'readonly' => true,
                    ],
                ],
            ],
            'course_fields' => [
                'id' => [
                    'name' => 'id',
                    'table' => 'activity_course',
                    'frontend_type' => 'hidden',
                    'backend_type' => 'string',
                    'title' => 'ID',
                    'label' => 'ID',
                    'label_alias' => 'ID',
                    'label_show' => true,
                    'searchable' => true,
                    'exportable' => true,
                    'visible' => true,
                    'attr' => [
                        'readonly' => true,
                    ],
                ],
                'name' => [
                    'name' => 'name',
                    'table' => 'activity_course',
                    'frontend_type' => 'text',
                    'backend_type' => 'string',
                    'title' => 'Name',
                    'label' => 'Name',
                    'label_alias' => 'Name',
                    'label_show' => true,
                    'searchable' => true,
                    'exportable' => true,
                    'visible' => true,
                    'rules' => ['required'],
                ],
                'description' => [
                    'name' => 'description',
                    'table' => 'activity_course',
                    'frontend_type' => 'textarea',
                    'backend_type' => 'textarea',
                    'title' => 'Description',
                    'label' => 'Description',
                    'label_alias' => 'Description',
                    'label_show' => true,
                    'searchable' => true,
                    'exportable' => true,
                    'visible' => true,
                    'rules' => [],
                ],
                'locale' => [
                    'name' => 'locale',
                    'table' => 'activity_course',
                    'frontend_type' => 'select',
                    'backend_type' => 'string',
                    'title' => 'Locale',
                    'label' => 'Locale',
                    'label_alias' => 'Locale',
                    'label_show' => true,
                    'searchable' => true,
                    'exportable' => true,
                    'visible' => true,
                    'rules' => ['required'],
                    'choices' => '{course_locales}',
                    'selected' => '',
                    'empty_value' => '--- select ---',
                ],
                'countries' => [
                    'name' => 'countries',
                    'table' => 'activity_course',
                    'frontend_type' => 'choice',
                    'backend_type' => 'string',
                    'title' => 'Countries',
                    'label' => 'Countries',
                    'label_alias' => 'Countries',
                    'label_show' => true,
                    'searchable' => true,
                    'exportable' => true,
                    'visible' => true,
                    'rules' => [],
                    'choices' => '{countries}',
                    'expanded' => true,
                    'multiple' => true,
                ],
                'path' => [
                    'name' => 'path',
                    'table' => 'activity_course',
                    'frontend_type' => 'text',
                    'backend_type' => 'string',
                    'title' => 'Path',
                    'label' => 'Path',
                    'label_alias' => 'Path',
                    'label_show' => true,
                    'searchable' => true,
                    'exportable' => true,
                    'visible' => true,
                    'rules' => [],
                    'attr' => [
                        'disabled' => true,
                        'readonly' => true,
                    ],
                ],
                'upload' => [
                    'name' => 'upload',
                    'frontend_type' => 'file',
                    'backend_type' => 'string',
                    'title' => 'Zip File Upload',
                    'label' => 'Zip File Upload',
                    'label_alias' => 'Zip File Upload',
                    'label_show' => true,
                    'searchable' => false,
                    'exportable' => false,
                    'visible' => false,
                    'help_block' => [
                        // @phpcs:disable Generic.Files.LineLength
                        'text' => 'File needs to be a zipped published Storyline file under 50 MB. It also should include JavaScripts for <code>completeCourse()</code> and <code>exitCourse()</code> to integrate with the Ignite platform. The record will be made <code>Active</code> automatically after the new file has been processed.',
                        // @phpcs:enable
                    ],
                    'rules' => [
                        'nullable',
                        'file',
                        'mimes:zip',
                        'max:52428800',
                    ],
                ],
                'status' => [
                    'name' => 'status',
                    'table' => 'activity_course',
                    'frontend_type' => 'select',
                    'backend_type' => 'string',
                    'title' => 'Status',
                    'label' => 'Status',
                    'label_alias' => 'Status',
                    'label_show' => true,
                    'searchable' => true,
                    'exportable' => true,
                    'visible' => true,
                    'rules' => ['required'],
                    'choices' => '{course_statuses}',
                    'selected' => '',
                    'empty_value' => '--- select ---',
                ],
                'created_at' => [
                    'name' => 'created_at',
                    'table' => 'activity_course_family',
                    'frontend_type' => 'text',
                    'backend_type' => 'datetime',
                    'title' => 'Created At',
                    'label' => 'Created At',
                    'label_alias' => 'Created At',
                    'label_show' => true,
                    'searchable' => true,
                    'exportable' => true,
                    'visible' => true,
                    'rules' => [],
                    'attr' => [
                        'readonly' => true,
                    ],
                ],
            ],
        ],
    ],
];
