<?php

namespace Ignite\Course\Listeners;

use Ignite\Activity\Entities\Type;
use Ignite\Core\Events\Menus\AdminMenuPreCompile;
use Ignite\Core\Models\Menu\Item;
use Nwidart\Modules\Facades\Module;

class AdminMenu
{
    /**
     * Handle the event.
     *
     * @param AdminMenuPreCompile $event
     * @return void
     */
    public function handle(AdminMenuPreCompile $event)
    {
        if (! Module::isEnabled('Activity')) {
            return;
        }

        $types = collect(config('course.types'))
            ->keys()
            ->map(function ($type, $index) {
                return $this->getItemFor($type, $index);
            });

        if (1 == $types->count()) {
            $item = $types->first();
            $item['position'] = config('course.admin_menu_position', 30);
            $item['icon'] = 'leanpub';
        } else {
            $defaultType = config('course.default_type');
            $item = [
                'url' => route('admin.course_family.index', ['type' => $defaultType]),
                'label' => __('Course::types.' . $defaultType . '.Courses'),
                'position' => config('course.admin_menu_position', 30),
                'allow' => auth()->user()->can("activity.course.all.browse"),
                'icon' => 'leanpub',
                'children' => $types->toArray(),
            ];
        }

        $event->getManager()->merge(
            $event->getManager()->hydrateItems(collect([$item]))
        );
    }

    /**
     * Get a menu item for a type.
     *
     * @param Type $type
     * @param int $index
     *
     * @return Item
     */
    protected function getItemFor($type, $index)
    {
        $position = ($index + 1) * 100;

        return [
            // 'type' => $type,
            'position' => $position,
            'url' => route('admin.course_family.index', ['type' => $type]),
            'label' => __('Course::types.' . $type . '.Courses'),
            'icon' => 'leanpub',
            'allow' => auth()->user()->can("activity.course.all.browse"),
            // 'children' => [],
        ];
    }
}
