<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCourseFamilyTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $courseTypes = config('course.types');
        foreach ($courseTypes as $config) {
            Schema::create($config['course_family_table'], function (Blueprint $table) use ($config) {
                $table->id();
                $table->foreignId('offer_id')->nullable()
                    ->constrained('activity_offer')
                    ->cascadeOnUpdate()
                    ->restrictOnDelete();
                $table->string('name')->nullable();
                $table->string('category')->nullable();
                $table->string('image')->nullable();
                $table->string('passing_score')->nullable();
                $table->integer('points')->nullable();
                $table->date('publish_start')->nullable();
                $table->date('publish_end')->nullable();
                $table->integer('num_active')->default(0);
                $table->integer('sequence')->nullable();
                $table->text('notes')->nullable();

                $table->softDeletes();
                $table->timestamps();

                $table->index('category');
                $table->index('publish_start');
                $table->index('publish_end');
                $table->index('num_active');
                $table->index('sequence');
            });

            \DB::statement('ALTER TABLE ' . $config['course_family_table'] . ' AUTO_INCREMENT = 100');
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        $courseTypes = config('course.types');
        foreach ($courseTypes as $config) {
            Schema::dropIfExists($config['course_family_table']);
        }
    }
}
