<?php

namespace Ignite\Course\Listeners;

use Ignite\Core\Events\Menus\NavigationMenuPreCompile;
use Ignite\Core\Events\Menus\UserMenuPreCompile;
use Ignite\Core\Models\Menu\Item;
use Ignite\Core\Models\Menu\NavigationMenu;

class CourseNavigationMenu
{
    /**
     * Handle the event.
     *
     * @param NavigationMenuPreCompile|UserMenuPreCompile $event
     */
    public function handle($event)
    {
        if (isset($event->event)) {
            $event = $event->event;
        }
        /** @var NavigationMenu $manager */
        $manager = $event->getManager();
        $types = array_keys(config('course.types'));

        foreach ($types as $type) {
            if ($event instanceof NavigationMenuPreCompile) {
                $this->updateNavigationMenu($manager, $type);
            } elseif ($event instanceof UserMenuPreCompile) {
                $this->updateUserMenu($manager, $type);
            }
        }
    }

    /**
     * @param  string $type
     * @return void
     */
    protected function updateNavigationMenu(NavigationMenu $manager, string $type): void
    {
        $position = config('course.nav_menu_position', 20);
        /** @var Ignite\Core\Models\Menu\Item $activityItem */
        $activityItem = $manager->get('/activity');
        /** @var Ignite\Core\Models\Menu\Item $courseItem */
        $courseItem = $manager->get('/activity/' . $type);

        /* remove previous menu items
         * -------------------------------------------------- */
        if ($activityItem) {
            // remove course out of submenu
            $activityItem->removeChild('/activity/course');
        }
        if ($courseItem) {
            // remove old course link
            $manager->remove('/activity/' . $type);
        }

        /* add new top level menu item for courses
         * -------------------------------------------------- */
        // @todo: if there is more than one course type, then create a submenu of courses
        $courseItem = app(Item::class, [
            'url' => course_route('activity.course.index'),
            'label' => trans('Course::types.course.Courses'),
            'position' => $position,
            'allow' => (auth()->user() ? auth()->user()->can('course.all.browse') : false),
        ]);
        $manager->add($courseItem);

        /* add to Accounts submenu
         * -------------------------------------------------- */
        $items = $manager->get('/participant/profile');
        if ($items) {
            $title = __('Course::types.' . $type . '.my_courses_title');
            $position = config('course.user_menu_position', 30);
            $items->addChild(new Item(url('/course/completed'), $title, $position));
        }
    }

    /**
     * @param  string $type
     * @return void
     */
    protected function updateUserMenu(NavigationMenu $manager, string $type): void
    {
        /* add to User submenu
         * -------------------------------------------------- */
        $title = __('Course::types.' . $type . '.my_courses_title');
        $position = config('course.user_menu_position', 30);
        $manager->add(new Item(url('/course/completed'), $title, $position));
    }
}
