<?php

namespace Ignite\Course\Console;

use Ignite\Course\Entities\Course;
use Ignite\Course\Jobs\InitializeCourse;
use Illuminate\Console\Command;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputOption;

/**
 * @codeCoverageIgnore
 */
class Initialize extends Command
{
    /**
     * The console command name.
     *
     * @var string
     */
    protected $name = 'course:initialize';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Given a course code, it sets up the course files and adds the needed code.';

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $code = $this->argument('course');
        $isDryRun = $this->option('dry-run');

        $course = Course::where('code', $code)->first();
        if (!$course) {
            $this->error("The course '{$code}' does not exist.");
            return;
        }

        InitializeCourse::dispatchNow($course, $this->output, $isDryRun);
    }

    /**
     * Get the console command arguments.
     *
     * @return array
     */
    protected function getArguments()
    {
        return [
            ['course', InputArgument::REQUIRED, 'The code of the new course.'],
        ];
    }

    /**
     * Get the console command options.
     *
     * @return array
     */
    protected function getOptions()
    {
        return [
            ['dry-run', null, InputOption::VALUE_NONE, 'Make it a dry run.', null],
        ];
    }
}
