<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCourseCompletionTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $courseTypes = config('course.types');
        foreach ($courseTypes as $config) {
            Schema::create($config['completion_table'], function (Blueprint $table) use ($config) {
                $table->id();
                $table->foreignId('activity_id')
                    ->constrained('activity')
                    ->cascadeOnUpdate()
                    ->restrictOnDelete();
                $table->foreignId($config['course_family_table'] . '_id')
                    ->constrained($config['course_family_table'])
                    ->cascadeOnUpdate()
                    ->restrictOnDelete();
                $table->string('course_name')->nullable();
                $table->string('locale');
                $table->integer('score')->nullable();

                $table->softDeletes();
                $table->timestamps();
                $table->index('locale');
            });

            \DB::statement('ALTER TABLE ' . $config['completion_table'] . ' AUTO_INCREMENT = 100');
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        $courseTypes = config('course.types');
        foreach ($courseTypes as $config) {
            Schema::dropIfExists($config['completion_table']);
        }
    }
}
