<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCourseTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $courseTypes = config('course.types');
        foreach ($courseTypes as $config) {
            Schema::create($config['course_table'], function (Blueprint $table) use ($config) {
                $table->id();
                $table->foreignId($config['course_family_table'] . '_id')->nullable()
                    ->constrained($config['course_family_table'])
                    ->cascadeOnUpdate()
                    ->restrictOnDelete();
                $table->string('name')->nullable();
                $table->text('description')->nullable();
                $table->string('locale')->nullable();
                $table->string('countries')->nullable();
                $table->string('path')->nullable();
                $table->string('status');
                $table->string('code')->nullable();
                $table->json('meta')->nullable();

                $table->softDeletes();
                $table->timestamps();

                $table->index('countries');
                $table->index('locale');
                $table->index('status');
                $table->unique('code');
            });
            \DB::statement('ALTER TABLE ' . $config['course_table'] . ' AUTO_INCREMENT = 100');
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        $courseTypes = config('course.types');
        foreach ($courseTypes as $config) {
            Schema::dropIfExists($config['course_table']);
        }
    }
}
