<?php

namespace Ignite\Course\Entities;

use Ignite\Activity\Entities\Activity;
use Ignite\Core\Entities\Base;
use Ignite\Course\Entities\Course;
use Illuminate\Database\Eloquent\SoftDeletes;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

/**
 * Ignite\Course\Entities\CourseCompletion
 *
 * @property int $id
 * @property int $activity_id
 * @property int $activity_course_family_id
 * @property string|null $course_name
 * @property string $locale
 * @property int|null $score
 * @property \Illuminate\Support\Carbon|null $deleted_at
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read Activity|null $activity
 * @property-read \Illuminate\Database\Eloquent\Collection|\Ignite\Core\Entities\Audit[] $audits
 * @property-read int|null $audits_count
 * @property-read Course|null $course
 * @property-read \Ignite\Course\Entities\CourseFamily|null $courseFamily
 * @method static \Illuminate\Database\Eloquent\Builder|CourseCompletion newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|CourseCompletion newQuery()
 * @method static \Illuminate\Database\Query\Builder|CourseCompletion onlyTrashed()
 * @method static \Illuminate\Database\Eloquent\Builder|CourseCompletion query()
 * @method static \Illuminate\Database\Eloquent\Builder|CourseCompletion whereActivityCourseFamilyId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|CourseCompletion whereActivityId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|CourseCompletion whereCourseName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|CourseCompletion whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|CourseCompletion whereDeletedAt($value)
 * @method static Builder|Base whereHasPermission(string $permission, ?\Ignite\Core\Entities\User $user = null)
 * @method static \Illuminate\Database\Eloquent\Builder|CourseCompletion whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|CourseCompletion whereLocale($value)
 * @method static \Illuminate\Database\Eloquent\Builder|CourseCompletion whereScore($value)
 * @method static \Illuminate\Database\Eloquent\Builder|CourseCompletion whereUpdatedAt($value)
 * @method static \Illuminate\Database\Query\Builder|CourseCompletion withTrashed()
 * @method static \Illuminate\Database\Query\Builder|CourseCompletion withoutTrashed()
 * @mixin \Eloquent
 */
class CourseCompletion extends Base implements AuditableContract
{
    use Auditable;
    use SoftDeletes;

    /**
     * The table name.
     * @var string
     */
    protected $table = 'activity_course_completion';

    /**
     * The attributes that should be cast.
     *
     * @var array
     */
    protected $casts = [
        'deleted_at' => 'datetime',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    /**
     * Should the timestamps be audited?
     *
     * @var bool
     */
    protected $auditTimestamps = false;

    /**
     * Custom Audit Driver
     *
     * @var \Ignite\Core\Audit\ParticipantDriver
     */
    protected $auditDriver = \Ignite\Core\Audit\GenericDriver::class;

    /**
     * Attributes to exclude from the Audit.
     *
     * @var array
     */
    protected $auditExclude = [];

    /**
     * Don't auto-increment, or set Primary Key = 0
     * @var boolean
     */
    public $incrementing = true;

    /**
     * The relationship to the activity record.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function activity()
    {
        return $this->hasOne(Activity::class, 'id', 'activity_id');
    }

    /**
     * The relationship to the course family record.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function courseFamily()
    {
        return $this->hasOne(CourseFamily::class, 'id', 'activity_course_family_id');
    }

    /**
     * The relationship to the course record.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function course()
    {
        return $this->hasOne(Course::class, 'id', 'activity_course_family_id')
            ->where('locale', $this->locale);
    }

    /**
     * The identifier for the record in the audit log.
     *
     * @return mixed
     */
    public static function getAuditFriendlyField()
    {
        return ['activity_id', 'course_name'];
    }
}
