<?php

namespace Ignite\Course\Domain\Activity\Form\Offer;

use Ignite\Activity\Contracts\OfferForm;
// use Ignite\Activity\Domain\Schema\Fields;
use Ignite\Activity\Models\Form\ActivityForm;
use Illuminate\Support\Collection;

class CourseCompletion extends ActivityForm implements OfferForm
{
    /**
     * Build the offer activity form.
     *
     * @return void
     */
    public function buildForm()
    {
        $this->fromSchema();

        $this->setFormOptions([
            'id' => 'course-completion-form',
            'files' => true,
        ]);
    }

    /**
     * @param  Collection $fields
     * @return array
     */
    public function formatters(Collection $fields)
    {
        return [
            'activity.data.locale' => function ($model) use ($fields) {
                return strtoupper($model->activity->data->locale) ?? '';
            }
        ];
    }
}
