@php
// do we show the options for 'see more languages' ?
$showMore = course_has_bablic()
    ? config('course.pages.course_index.show_more_languages.if_bablic_on')
    : config('course.pages.course_index.show_more_languages.if_bablic_off');
@endphp

@section('title_category')
<h1 class="category-title">{{ $category }}</h1>
@show

@section('top_block')
{!! __("Course::types.{$type->code}.index_courses_top_block") !!}
<span class="pb-3">&nbsp;</span>
@show

<table id="coursesTable" class="table table-bordered display">
    <thead>
        <tr>
            <th class="bg-primary dt-head-center">{{ __("Course::types.{$type->code}.labels.date_added") }}</th>
            <th class="bg-primary dt-head-center">{{ __("Course::types.{$type->code}.labels.name") }}</th>
            <th class="bg-primary dt-head-center">{{ __("Course::types.{$type->code}.labels.status") }}</th>
            @if (config("course.pages.course_index.show_points"))
            <th class="bg-primary dt-head-center">{{ __("Course::types.{$type->code}.labels.points") }}</th>
            @endif
            <th class="bg-primary dt-head-center">{{ __("Course::types.{$type->code}.labels.take_course") }}</th>
        </tr>
    </thead>
    <tbody>
        @forelse ($courseFamilies as $courseFamily)
            @php
            // show even inactive ones in case they already completed it
            // just do not show the button to take it if inactive
            $course = $courseFamily->courses->first();
            $others = $courseFamily->courses->filter(function ($other) use ($course) {
                return ($other->isActive() && $other->id != $course->id);
            });
            @endphp
            <tr class="course-row">
                <td class="dt-body-center">
                    @if ($courseFamily->publish_start){{ $courseFamily->publish_start->format('Y-m-d 00:00:00P') }}
                    @else{{ $courseFamily->created_at->format('Y-m-d 00:00:00P') }}
                    @endif
                </td>
                <td class="dt-body-left">
                    @if ($courseFamily->hasThumbnail())
                        <a class="course-thumbnail" href="{{ $courseFamily->course->url() }}">
                            <img src="{{ $courseFamily->getThumbnailUrl() }}" alt="{{ $courseFamily->course->name }}" width="100" class="pull-left mr-1">
                        </a>
                    @endif
                    <p class="course-title"><span bablic-exclude>{{ $course->name }}</span></p>
                    @if ($course->description)
                        <p class="course-description ml-1 mt-1 mb-1"><span bablic-exclude>{{ $course->description }}</span></p>
                    @endif
                    @if (count($others) > 0 && true == $showMore)
                    <div class="extra-locales">
                        <p class="more-links small ml-1 mt-0 mb-0">
                            <i><a href="#">{{ __("Course::types.{$type->code}.labels.see_more_languages") }}</a></i>
                        </p>
                        @foreach ($others as $other)
                        <p class="locale locale-{{ $other->locale }} p-0 m-1" style="display: none;">
                            <a class="btn btn-sm btn-primary" href="{{ $other->url() }}" role="button">Start [{{ strtoupper($other->locale) }}]</a>
                            <span bablic-exclude>{{ $other->name }}</span>
                        </p>
                        @endforeach
                    </div>
                    @endif
                </td>
                <td class="dt-body-center">
                    @if (isset($completions[$courseFamily->id]) && !empty($completions[$courseFamily->id]))
                        {{ __("Course::types.{$type->code}.labels.completed") }}<br />
                        {{ $completions[$courseFamily->id]->created_at->format('Y-m-d') }}
                    @endif
                </td>
                @if (config("course.pages.course_index.show_points"))
                <td class="dt-body-center">
                    {{ is_numeric($courseFamily->points) ? Format::amount($courseFamily->points) : 'N/A' }}
                </td>
                @endif
                <td class="dt-body-center">
                    @if ($course->isActive())
                        <a class="btn btn-sm btn-primary" href="{{ $course->url() }}" role="button">
                            {{ __("Course::types.{$type->code}.labels.start_course") }}
                        </a>
                    @endif
                </td>
            </tr>

        @empty
        <tr>
            @php
            $colspan = 4;
            if (config("course.pages.course_index.show_points")) {
                $colspan++;
            }
            @endphp
            <td class="text-danger text-center" colspan="{{ $colspan }}">
                {{ __("Course::types.{$type->code}.labels.no_course_found") }}
            </td>
        </tr>
        @endforelse
    </tbody>
</table>

@push('styles')
<link href="//cdn.datatables.net/v/bs/jszip-3.10.1/dt-2.1.8/af-2.7.0/b-3.2.0/b-colvis-3.2.0/b-html5-3.2.0/b-print-3.2.0/cr-2.0.4/date-1.5.4/fc-5.0.4/fh-4.0.1/kt-2.12.1/r-3.0.3/rg-1.5.1/rr-1.5.0/sc-2.4.3/sb-1.8.1/sp-2.3.3/sl-2.1.0/sr-1.4.1/datatables.min.css" rel="stylesheet">
<style type="text/css">
div.dt-container {
    > .row {
        margin-bottom: 5px;
    }
    div.dt-search input {
        margin-left: 0px;
    }
    div.dt-length select {
        margin-left: 5px;
        margin-right: 0px;
    }
}
</style>
@endpush

@push('scripts')
    @if($courseFamilies->count() > 0)
    <script src="//cdn.datatables.net/v/bs/jszip-3.10.1/dt-2.1.8/af-2.7.0/b-3.2.0/b-colvis-3.2.0/b-html5-3.2.0/b-print-3.2.0/cr-2.0.4/date-1.5.4/fc-5.0.4/fh-4.0.1/kt-2.12.1/r-3.0.3/rg-1.5.1/rr-1.5.0/sc-2.4.3/sb-1.8.1/sp-2.3.3/sl-2.1.0/sr-1.4.1/datatables.min.js" defer></script>
    <script type="text/javascript">
    function showMoreLanguages(event) {
        $(event.target).closest('.extra-locales').find('.locale').show();
        $(event.target).hide();
        event.preventDefault();
        event.stopPropagation();
    }
    $(document).ready(function() {
        $.fn.dataTable.Buttons.defaults.dom.button.className = 'btn btn-default btn-sm';
        $('#coursesTable').DataTable({
            order: [
                [0, 'desc'],
                [1, 'asc'],
            ],
            lengthMenu: [50, 100, 250, 500, 1000],
            pageLength: 100,
            dom: '<"row"<"col-sm-6"f><"col-sm-6 text-right"l>><"panel"<"panel-body"<"negative-margin table-responsive"t>>><"row"<"col-sm-8 text-left"p><"col-sm-4 pt-1 pb-1 text-right"i>>',
            responsive: true,
            autoWidth: true,
            columnDefs: [
                { targets: 0, render: DataTable.render.date() },
            ],
            language: {
                search: '',
                searchPlaceholder: "{{ __("Course::types.{$type->code}.labels.dt_searchPlaceholder") }}",
                lengthMenu: "{{ __("Course::types.{$type->code}.labels.dt_lengthMenu") }}",
            }
        });
        $('.more-links').on('click', function(e) {
            showMoreLanguages(e);
        });
    });
    </script>
    @endif
@endpush