@extends('Course::layouts.admin')

@section('meta_title', $pageTitle = __("Course::types.{$type->code}.Course"))
@section('page_heading', $courseFamily->name)
@section('page_subheading', $pageTitle)

@section('breadcrumb')
    @parent
    <li class="active"><a href="{{ route('admin.course_family.index', ['type' => $type]) }}">{{ __("Course::types.{$type->code}.Course Family") }}</a></li>
    <li class="active"><a href="{{ route('admin.course_family.show', ['type' => $type, 'courseFamily' => $courseFamily]) }}">{{ $courseFamily->name }}</a></li>
    <li class="active"><a href="{{ route('admin.course.index', ['type' => $type, 'courseFamily' => $courseFamily]) }}">{{ $pageTitle }}</a></li>
@endsection

@section('tab_content')
    {!! $dataTable->table(['class' => 'table dt-table-border']) !!}
@endsection

@section('js')
    @parent
    {!! $dataTable->scripts() !!}
    <script type="text/javascript">
        $(document).ready(function() {
            var $dataTable = $('#dataTableBuilder');
            var buttons = [];
            @can('activity.course.all.create')
            buttons.push({
              text: '<span class="fa fa-plus text-success"></span> <span class="text-success">Create</span>',
              action: function (e) {
                e.preventDefault();
                window.location.href = '{{ route('admin.course.create', ['type' => $type, 'courseFamily' => $courseFamily]) }}';
              }
            });
            @endcan
            $dataTable.customButtons({
                buttons: buttons
            });
        });
    </script>
@endsection
