@extends('Course::layouts.admin')

@section('meta_title', $pageTitle = __("Course::types.{$type->code}.Course"))
@section('page_heading', $pageTitle)

@section('breadcrumb')
    @parent
    <li class="active"><a href="{{ route('admin.course_family.index', ['type' => $type]) }}">{{ __("Course::types.{$type->code}.Course Family") }}</a></li>
    <li class="active"><a href="{{ route('admin.course_family.show', ['type' => $type, 'courseFamily' => $courseFamily]) }}">{{ $courseFamily->name }}</a></li>
    <li><a href="{{ route('admin.course.index', ['type' => $type, 'courseFamily' => $courseFamily]) }}">{{ $pageTitle }}</a></li>
@endsection

@section('page_content')
    <div class="row form-affix-container">
        @include('Course::admin.partials.course', ['mode' => 'create', 'type' => $type, 'courseFamily' => $courseFamily])
        <div class="col-sm-9 form-affix-body">
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title">Create</h3>
                </div>
                <div class="box-body">
                    {!! form($form) !!}
                </div>
            </div>
        </div>
    </div>
@endsection

@include('Course::admin.partials.course_upload')
