<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddCourseFamilyThumbnailField extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $courseTypes = config('course.types');
        foreach ($courseTypes as $config) {
            Schema::table($config['course_family_table'], function (Blueprint $table) use ($config) {
                $table->string('thumbnail')->after('points')->nullable();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        $courseTypes = config('course.types');
        foreach ($courseTypes as $config) {
            Schema::table($config['course_family_table'], function (Blueprint $table) use ($config) {
                $table->dropColumn('thumbnail');
            });
        }
    }
}
