<?php

namespace Ignite\Course\Domain\Activity;

use Ignite\Activity\Contracts\TypeStrategyInterface;
use Ignite\Activity\Entities\Offer;
use Illuminate\Http\Request;

class CourseStrategy implements TypeStrategyInterface
{
    /**
     * The type of the activity this strategy is for.
     *
     * @var string
     */
    protected string $type;

    /**
     * @param string $type
     */
    public function __construct($type)
    {
        $this->type = $type;
    }

    /**
     * Returns new URL to redirect for ActivityTypeController::index()
     * for this activity type, if not the default.
     *
     * @param  Offer       $offer
     * @param  Request     $request
     * @return string|null $url
     */
    public function activityTypeCreateRedirect(Offer $offer, Request $request): ?string
    {
        return $this->offerUrl($offer);
    }

    /**
     * Returns new URL to redirect for ActivityTypeController::create()
     * for this activity type, if not the default.
     *
     * @param  Request     $request
     * @return string|null $url
     */
    public function activityTypeIndexRedirect(Request $request): ?string
    {
        return course_route('activity.course.index', [
            'type' => $this->type,
        ]);
    }

    /**
     * Returns new URL for Offer::url() for this activity type, if not the default.
     *
     * @param  Offer       $offer
     * @return string|null $url
     */
    public function offerUrl(Offer $offer): ?string
    {
        return course_route('activity.course.index', [
            'type' => $offer->type->code,
            'offer' => $offer->code,
        ]);
    }
}
