# Changelog

## 1.0.4 - 2025-09-15

### Changes
- Renamed `Simple` rule class to `CourseDefault` in `src/Domain/Activity/Rules/`
- Adjusted label and related_name in `course_type.json` for clarity
- Updated `readme.md` with instructions for file upload size config changes.

### Upgrading
- Update the rule in the `activity_offer_rule` and `activity_rule` table.

## 1.0.3 - 2025-09-11

### Changes
- Add/update show_points config to `course_index` and `course_completed` pages.
- Allow custom date format for completed courses via config.
- Change `storyline-lms.js` to POST to `/course/complete` instead of `/course/score`.
- Add `/score` route as an alias for `/complete` for compatibility.

### Upgrading
- Update your `public/vendor/ignite-course/js/storyline-lms.js` to submit to `/course/complete` instead of `/course/score` if it is not working there.

## 1.0.2 - 2025-09-10

### Changes
- Changed all course permission keys from `course.all.*` to `activity.course.all.*` in code, configs, routes, and views.
- Refactored `/course/completed` blade to support both legacy and new datatable partials. Added config option to toggle between legacy and new datatable views.

### Upgrading
- You can fix the permissions (if using the defaults) with:
```sql
UPDATE core_permission SET `key` = 'activity.course.all.browse' WHERE `key` = 'course.all.browse';
UPDATE core_permission SET `key` = 'activity.course.all.view'   WHERE `key` = 'course.all.view';
UPDATE core_permission SET `key` = 'activity.course.all.update' WHERE `key` = 'course.all.update';
UPDATE core_permission SET `key` = 'activity.course.all.create' WHERE `key` = 'course.all.create';
UPDATE core_permission SET `key` = 'activity.course.all.delete' WHERE `key` = 'course.all.delete';
INSERT IGNORE INTO core_permission (`key`, `description`, `is_user_defined`, `status`, `created_at`, `updated_at`) VALUES ('activity.course.all.view', 'View the course for all types', 0, 1, NOW(), NOW());
INSERT IGNORE INTO core_group_permission (`group_id`, `permission_id`, `created_at`, `updated_at`)
	SELECT `core_group`.`id`, `core_permission`.`id`, NOW(), NOW() FROM `core_group`, `core_permission`
	WHERE `core_group`.`key` IN ('admin', 'manager', 'specialist') AND `core_permission`.`key` LIKE 'activity.course.%';
INSERT IGNORE INTO core_group_permission (`group_id`, `permission_id`, `created_at`, `updated_at`)
	SELECT `core_group`.`id`, `core_permission`.`id`, NOW(), NOW() FROM `core_group`, `core_permission`
	WHERE `core_group`.`key` IN ('client') AND `core_permission`.`key` LIKE 'activity.course.all.view';
INSERT IGNORE INTO core_group_permission (`group_id`, `permission_id`, `created_at`, `updated_at`)
	SELECT `core_group`.`id`, `core_permission`.`id`, NOW(), NOW() FROM `core_group`, `core_permission`
	WHERE `core_group`.`key` IN ('participant') AND `core_permission`.`key` LIKE 'activity.course.all.browse';
```

## 1.0.0 - 2025-09-02

### Changes
- Renamed "Course Default" offer/rule to "Course" in JSON configs and forms
- Changed approved status type from `normal` to `final`
- Improved category view: show title if no image is set
- Added auto-redirect to single category in CourseController
- Made category images optional in CourseListComposer
- Updated CourseRepository to handle missing default type safely

## 0.9.1 - 2025-03-10
- Pre-release