# Course - Activity Module package

## Server

You may need to update your server "PHP > Max File Upload Size" through Forge. We recommend that 51 MB is a good default maximum.

## Publish

You need these in your /public folder.
`php artisan vendor:publish --tag=ignite-course-assets`

If you want to overwrite with your own config:
`php artisan vendor:publish --tag=ignite-course-config`

If you want to overwrite with your own views:
`php artisan vendor:publish --tag=ignite-course-views`

If you want to use your own migrations:
`php artisan vendor:publish --tag=ignite-course-migration`

If you want to overwrite with your own translations:
`php artisan vendor:publish --tag=ignite-course-translations`

## View Blade

If you choose to publish specific view blade files into your local resource
folder, and if you want to over-write a view blade, you can refer back to the
original view blade (without copying the whole file), you can use the namespace
'parent-course'. For example, in your `resources/views/vendor/ignite-course/course/index.blade.php`

```php
@extends('parent-course::course.index')

@section('content_footer')
    {{-- no content --}}
@endsection
```

## Config

### Activity.php

If have not already, publish `vendor/ignite/modules/Activity/config/config.php` to `config\activity.php`.

Then add schema course to it:

```php
'schema' => [
	// ...
	'course' => 'forms/course_completion.json',
	// ...
],
```

### form/course_completion.json

Copy the sample file into your `<THEMENAME>` folder:

`cp vendor/ignite/course/resources/assets/forms/course_completion.sample.json themes/<THEMENAME>/forms/course_completion.json`

or whatever your course completion name is.

### config/course.php

You can publish `ignite-course-config` to get `config/course.php`, or you can create it yourself instead and have this to start, so it can merge the original course configurations better.

```php
$parent = include base_path('vendor/ignite/course/config/course.php');
return array_replace_recursive($parent, [
	/* custom configs */
]);
```

## Migration

If the `config('course.use_default_migration')` is `true`, then no need to create your own migration. You can just run `php artisan migrate` to run the migrations in `vendor\ignite\course\data\migrations`.

If it is set to `false`, then you need to create your own migration files in your `Program` module. Then `CourseServiceProvider` will not use the default migration folder to run the migrations.

## Seeding

### Files

If you did not want to use the default ones, then copy these and use them:
`mkdir modules/Program/database/data`
`cp vendor/ignite/course/database/data/course_type.json modules/Program/database/data/course_type.json`
`cp vendor/ignite/course/database/data/course_report.json modules/Program/database/data/course_report.json`

You may want your own list of courses to initialize:
`cp vendor/ignite/course/database/data/course_list.json.sample modules/Program/database/data/course_list.json`

### Artisan

When you run the seeder for the Activity module (`php artisan module:seed Activity`), it should also seed the Course package.

Or you can seed for course specifically with `php artisan db:seed --class="Ignite\Course\Database\Seeders\CourseSeeder"`.