<?php

namespace Ignite\Course\Http\Forms;

use Ignite\Core\Models\Form\CoreForm;

class CourseFamilyForm extends CoreForm
{
    /**
     * Build the enrollment form.
     *
     * @return void
     * @throws Exception
     */
    public function buildForm()
    {
        $this->setFormOptions([
            'id' => 'course-family-form',
        ]);

        $this->buildFromSchema(config("course.default_type"));

        if (isset($this->data['readonly'])) {
            /** @var FormField $field */
            foreach ($this->fields as $field) {
                $field->setOption('attr.readonly', true);
                $field->disable();

                if (in_array($field->getType(), ['button', 'submit', 'reset'])) {
                    $this->remove($field->getName());
                }
            }
        } else {
            $this->remove('num_active');
            $this->remove('created_at');
        }

        $this->fixDateField('publish_start');
        $this->fixDateField('publish_end');
    }

    /**
     * Fixes the date field by setting the correct date format instead of datetime.
     *
     * @param  string $field
     */
    protected function fixDateField(string $field)
    {
        $field = $this->getField($field);
        $value = $field->getValue();
        if (! $value) {
            return;
        }

        if (!is_string($value)) {
            $field->setOption('value', $value->format('Y-m-d'));
        }
    }

    /**
     * Get the schema.
     *
     * @param string $type
     * @return array
     */
    protected function getSchema(string $type)
    {
        $fields = config("course.types.{$type}.course_family_fields");
        $fields = array_merge(
            $fields,
            [
                'submit' => [
                    'frontend_type' => 'submit',
                    'name' => 'submit',
                    'label' => 'Submit',
                    'attr' => [
                        'id' => 'submit-course',
                        'class' => 'btn btn-primary pl-4 pr-4'
                    ],
                    'wrapper' => [
                        'class' => 'form-button text-right'
                    ],
                ],
            ],
        );

        $schema = [
            'fields' => $fields,
        ];

        $this->schemaIndexFields($schema);
        return $this->schemaAlter($schema);
    }
}
