@extends('layouts.site')

@section('meta_title', __("Course::types.{$type->code}.my_courses_title"))

@section('content_header')
@include('partials._components._heading', ['heading' => __("Course::types.{$type->code}.my_courses_title")])
@endsection

@section('content')
<section class="container activity-index">
    <div class="row pb-4">
        <div class="col-md-4">
            @include('partials._components._user-menu')
        </div>
        <div class="col-md-8 mt-4 panel pt-1">
            <table id="courseCompletionsTable" class="table table-bordered display">
                <thead>
                    <tr>
                        <th class="bg-primary dt-head-center">{{ __("Course::types.{$type->code}.labels.date") }}</th>
                        <th class="bg-primary dt-head-center">{{ __("Course::types.{$type->code}.labels.category") }}</th>
                        <th class="bg-primary dt-head-center">{{ __("Course::types.{$type->code}.labels.description") }}</th>
                        @if (config("course.types.{$type->code}.pages.completed.show_points"))
                        <th class="bg-primary dt-head-center">{{ trans_choice('Core::core.common.points', 2) }}</th>
                        @endif
                    </tr>
                </thead>
                <tbody>
                    @forelse($submissions as $submission)
                    <tr>
                        <td>{{ $submission->created_at->format('Y-m-d 00:00:00P') }}</td>
                        <td>{{ $submission->activity->data->courseFamily->category ?? 'N/A' }}</td>
                        <td><span bablic-exclude>{{ $submission->activity->data->course_name ?? ($submission->activity->data->course->name ?? 'N/A') }}</span></td>
                        @if (config("course.types.{$type->code}.pages.completed.show_points"))
                        <td class="text-right">{{ Format::amount($submission->value) }}</td>
                        @endif
                    </tr>
                    @empty
                    <tr>
                        @php
                        $colspan = 3;
                        if (config("course.types.{$type->code}.pages.completed.show_points")) {
                            $colspan++;
                        }
                        @endphp
                        <td colspan="{{ $colspan }}" class="text-danger text-center">{{ __("Course::types.{$type->code}.labels.no_completions_found") }}</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</section>
@endsection

@push('styles')
<link href="//cdn.datatables.net/v/bs/jszip-3.10.1/dt-2.1.8/af-2.7.0/b-3.2.0/b-colvis-3.2.0/b-html5-3.2.0/b-print-3.2.0/cr-2.0.4/date-1.5.4/fc-5.0.4/fh-4.0.1/kt-2.12.1/r-3.0.3/rg-1.5.1/rr-1.5.0/sc-2.4.3/sb-1.8.1/sp-2.3.3/sl-2.1.0/sr-1.4.1/datatables.min.css" rel="stylesheet">
<style type="text/css">
div.dt-container {
    > .row {
        margin-bottom: 5px;
    }
    div.dt-search input {
        margin-left: 0px;
    }
    div.dt-length select {
        margin-left: 5px;
        margin-right: 0px;
    }
}
</style>
@endpush

@push('scripts')
    @if($submissions->count() > 0)
    <script src="//cdn.datatables.net/v/bs/jszip-3.10.1/dt-2.1.8/af-2.7.0/b-3.2.0/b-colvis-3.2.0/b-html5-3.2.0/b-print-3.2.0/cr-2.0.4/date-1.5.4/fc-5.0.4/fh-4.0.1/kt-2.12.1/r-3.0.3/rg-1.5.1/rr-1.5.0/sc-2.4.3/sb-1.8.1/sp-2.3.3/sl-2.1.0/sr-1.4.1/datatables.min.js" defer></script>
    <script type="text/javascript">
    $(document).ready(function() {
        $.fn.dataTable.Buttons.defaults.dom.button.className = 'btn btn-default btn-sm';
        $('#courseCompletionsTable').DataTable({
            order: [
                [0, 'desc'],
                [1, 'asc'],
                [2, 'asc'],
            ],
            lengthMenu: [50, 100, 250, 500, 1000],
            pageLength: 100,
            dom: '<"row"<"col-sm-4"f><"col-sm-4 text-right"B><"col-sm-4 text-right"l>><"panel"<"panel-body"<"negative-margin table-responsive"t>>><"row"<"col-sm-8 text-left"p><"col-sm-4 pt-1 pb-1 text-right"i>>',
            responsive: true,
            autoWidth: true,
            columnDefs: [
                { targets: 0, render: DataTable.render.date() },
            ],
            language: {
                search: '',
                searchPlaceholder: "{{ __("Course::types.{$type->code}.labels.dt_searchPlaceholder") }}",
                lengthMenu: "{{ __("Course::types.{$type->code}.labels.dt_lengthMenu") }}",
            },
            buttons: [
                'csv',
                'excel',
                'print',
                'copy',
            ]
        });
    });
    </script>
    @endif
@endpush
