{!! __("Course::types.{$type->code}.index_categories_top_block") !!}

<div class="row course_categories_list">
    @forelse ($categories as $category)
    <div class="col-md-4">
        @if ($category->numCourses > 0 || !$hideEmptyCategories)
        <div class="card mb-4">
            <a class="category-image" href="{{ course_route('activity.course.index', ['type' => $type->code, 'offer' => $offer->code, 'category' => $category->name]) }}">
                <img class="card-img-top" src="{{ Theme::image($category->image) }}" alt="{{ $category->name }}" width="100%">
            </a>
            <div class="card-body p-1">
                <strong>
                    <a class="category-title" href="{{ course_route('activity.course.index', ['type' => $type->code, 'offer' => $offer->code, 'category' => $category->name]) }}">
                        {{ $category->name }}
                    </a>
                </strong>
            </div>
            <div class="card-footer p-1 bg-primary">
                {{ $category->numCompletions }} / {{ $category->numCourses }} {{ __("Course::types.{$type->code}.Course Completions") }}
            </div>
        </div>
        @endif
    </div>
    @empty
    <div class="col-md-12">
        <div class="alert alert-warning" role="alert">
            No categories found.
        </div>
    </div>
    @endforelse
</div>
