@extends('Course::layouts.admin')

@section('meta_title', $pageTitle = __("Course::types.{$type->code}.Course"))
@section('page_heading', $model->name)
@section('page_subheading', $pageTitle)

@section('breadcrumb')
    @parent
    <li class="active"><a href="{{ route('admin.course_family.index', ['type' => $type]) }}">{{ __("Course::types.{$type->code}.Course Family") }}</a></li>
    <li class="active"><a href="{{ route('admin.course_family.show', ['type' => $type, 'courseFamily' => $model->courseFamily]) }}">{{ $model->courseFamily->name }}</a></li>
    <li><a href="{{ route('admin.course.index', ['type' => $type, 'courseFamily' => $model->courseFamily]) }}">{{ $pageTitle }}</a></li>
    <li class="active">{{ $model->name }}</li>
@endsection

@section('page_content')
    <div class="row form-affix-container">
        @include('Course::admin.partials.course', ['mode' => 'show', 'type' => $type, 'model' => $model])
        <div class="col-sm-9 form-affix-body">
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h2 class="box-title">View</h2>
                </div>
                <div class="box-body">
                    {!! form($form) !!}
                </div>
            </div>
        </div>
    </div>
@endsection
