function onCourseLoad() {
	window.isCourseCompleted = false;
	window.isCoursePassed = false;
}
function completeCourse() {
	if (window.isCoursePassed) {
		// already sent pass completion
		return
	}

	var p = GetPlayer();
	// allow for some mispellings
	var status = p.GetVar("varResultStatus") || p.GetVar("varResultsStatus") || '';
	var data = {
		title: p.GetVar("varCourseTitle"),
		points: p.GetVar("varScorePoints") || p.GetVar("varScorePoint") || p.GetVar("varScorePnts"),
		percent: p.GetVar("varScorePctg") || p.GetVar("varScorePercent") || p.GetVar("varScorePercentage"),
		status: status,
		path: window.location.pathname
	};

	// update this in https://brightspot.atlassian.net/wiki/spaces/I3/pages/2352840705/Course+Learning+TBD

	var xhr = new XMLHttpRequest();
	// false = synchronous request, so that this finishes
	// before we do something else, like a redirect or close browser tab.
	xhr.open('POST', '/course/score', false);
	xhr.setRequestHeader('Content-Type', 'application/json');
	xhr.send(JSON.stringify(data));
	xhr.onreadystatechange = function() {
		if (xhr.readyState == 4 && xhr.status == 200) {
			window.isCourseCompleted = true;
			if (data.percent == 100 || data.status.toUpperCase() == 'PASS') {
				window.isCoursePassed = true;
			}
			// console.log(xhr.responseText);
		}
	};
	xhr.onerror = function() {
		console.error('Error!');
		console.error(data);
	}
}
function exitCourse() {
	if (!window.isCourseCompleted) {
		window.location.href = '/course/exit';
		return;
	}

	var url = '/course/end?path=' + encodeURIComponent(window.location.pathname);
	window.location.href = url;
}
function restartCourse() {
	window.isCourseCompleted = false;
	window.isCoursePassed = false;
}
// alias for some older versions
function sendTest() {
	completeCourse();
}

document.addEventListener('DOMContentLoaded', function() {
	onCourseLoad();
});