<?php

namespace Ignite\Course\Providers;

use Ignite\Activity\Events\ActivityNavigationMenuCompleted;
use Ignite\Activity\Events\ActivitySeederCompleted;
use Ignite\Activity\Events\ActivitySubmissionStatusChanged;
use Ignite\Core\Events\Menus\AdminMenuPreCompile;
use Ignite\Core\Events\Menus\UserMenuPreCompile;
use Ignite\Course\Contracts\CourseRepositoryInterface;
use Ignite\Course\Listeners\AdminMenu;
use Ignite\Course\Listeners\CourseNavigationMenu;
use Ignite\Course\Listeners\RunCourseSeeder;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event listener mappings for the application.
     *
     * @var array
     */
    protected $listen = [
        ActivitySeederCompleted::class => [
             RunCourseSeeder::class
        ],
        AdminMenuPreCompile::class => [
            AdminMenu::class
        ],
        ActivityNavigationMenuCompleted::class => [
            CourseNavigationMenu::class
        ],
        UserMenuPreCompile::class => [
            CourseNavigationMenu::class
        ],
        ActivitySubmissionStatusChanged::class => [
            [CourseRepositoryInterface::class, 'statusChanged'],
        ],
    ];

    /**
     * The subscriber classes to register.
     *
     * @var array
     */
    protected $subscribe = [];
}
