<?php

namespace Ignite\Course\Database\Seeders;

use Ignite\Activity\Entities\Offer;
use Ignite\Core\Database\Seeders\AbstractSeeder;
use Ignite\Course\Database\Seeders\Traits\CourseSeederPath;
use Ignite\Course\Entities\Course;
use Ignite\Course\Entities\CourseFamily;
use Illuminate\Support\Carbon;
use InvalidArgumentException;

/**
 * php artisan db:seed --class="Ignite\Course\Database\Seeders\CourseListSeeder"
 */
class CourseListSeeder extends AbstractSeeder
{
    use CourseSeederPath;

    /**
     * The path to the data file.
     *
     * @var string
     */
    protected $file = 'course_list.json';

    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        parent::run();

        try {
            $strategy = $this->strategy('json', [
                'filepath' => $this->getFilepath($this->file)
            ]);
        } catch (InvalidArgumentException $e) {
            // if no file, that's ok.
            echo "No course_list.json file to seed with." . PHP_EOL;
            return;
        }

        $sources = $strategy->run();

        // \Illuminate\Support\Facades\Schema::disableForeignKeyConstraints();
        // \DB::table('activity_course')->truncate();

        foreach ($sources as $source) {
            try {
                $offer = Offer::where('code', $source['offer'])->firstOrFail();
                $source['offer_id'] = $offer->id;
                unset($source['offer']);

                $courses = $source['locales'];
                unset($source['locales']);

                $courseFamily = CourseFamily::updateOrCreate(['name' => $source['name']], $source);
                foreach ($courses as $data) {
                    Carbon::setTestNow(now()->addDays(rand(0, 10)));
                    $courseFamily->courses()->updateOrCreate(
                        ['locale' => $data['locale']],
                        $data
                    );
                }
            } catch (\Exception $e) {
                echo $e->getMessage() . PHP_EOL;
                continue;
            }
        }
    }
}
