@extends('Course::layouts.admin')

@section('meta_title', $pageTitle = __("Course::types.{$type->code}.Course Family"))
@section('page_heading', $pageTitle)

@section('breadcrumb')
    @parent
    <li class="active"><a href="{{ route('admin.course_family.index', ['type' => $type]) }}">{{ $pageTitle }}</a></li>
@endsection

@section('tab_content')
    {!! $dataTable->table(['class' => 'table dt-table-border']) !!}
@endsection

@section('js')
    @parent
    {!! $dataTable->scripts() !!}
    <script type="text/javascript">
        $(document).ready(function() {
            var $dataTable = $('#dataTableBuilder');
            var buttons = [];
            @can('activity.course.create')
            buttons.push({
              text: '<span class="fa fa-plus text-success"></span> <span class="text-success">Create</span>',
              action: function (e) {
                e.preventDefault();
                window.location.href = '{{ route('admin.course_family.create', ['type' => $type]) }}';
              }
            });
            @endcan
            $dataTable.customButtons({
                buttons: buttons
            });
        });
    </script>
@endsection
