@extends('Course::layouts.admin')

@section('meta_title', $pageTitle = __("Course::types.{$type->code}.Course Family"))
@section('page_heading', $model->name)
@section('page_subheading', $pageTitle)

@section('breadcrumb')
    @parent
    <li><a href="{{ route('admin.course_family.index', ['type' => $type]) }}">{{ $pageTitle }}</a></li>
    <li class="active">{{ $model->name }}</li>
@endsection

@section('page_content')
    <div class="row form-affix-container">
        @include('Course::admin.partials.course_family', ['mode' => 'history', 'type' => $type, 'model' => $model])
        <div class="col-sm-9 form-affix-body">
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h2 class="box-title">History</h2>
                </div>
                <div class="box-body">
                    {!! $dataTable->table(['class' => 'table dt-table-border']) !!}
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
    @parent
    {!! $dataTable->scripts() !!}
@endsection
