<?php

namespace Ignite\Core\Models\Grid;

use Ignite\Core\Models\Grid\TransactionFormatter;

class WaitingTransactionsFormatter extends TransactionFormatter
{
    /**
     * Format a checkbox for selecting entries in the grid.
     *
     * @param object $model
     * @return \Illuminate\Support\HtmlString
     */
    public function checkbox($model)
    {
        return $this->formatCheckbox($model->id);
    }

    /**
     * The balance of transactions for the user.
     *
     * @param object $model
     * @return string
     */
    public function actions($model)
    {
        $actions = [];

        if (auth()->user()->can('core.transactions.waiting.assign')) {
            $actions[] = [
                'link' => route('admin.transactions.resource.edit', ['id' => $model->id]),
                'label' => 'Assign to Participant',
                'icon' => 'exchange'
            ];
        }

        return $this->html($this->buttons($actions));
    }
}
