<?php

namespace Ignite\Core\Models\Grid;

use Ignite\Core\Entities\Filters\QueryPermissionFilters;
use Ignite\Core\Entities\Report;
use Illuminate\Database\DatabaseManager;
use Yajra\DataTables\DataTables;

class ReportTable extends EloquentTable
{
    /** @var DataTables */
    protected $datatables;

    /** @var ReportFormatter */
    protected $formatter;

    /**
     * ReportTable constructor.
     *
     * @param DataTables $datatables
     * @param DatabaseManager $databaseManager
     * @param ReportFormatter $formatter
     * @param array $params
     */
    public function __construct(
        DataTables      $datatables,
        DatabaseManager $databaseManager,
        ReportFormatter $formatter,
        array           $params = []
    ) {
        parent::__construct($datatables, $databaseManager, $params);

        $this->formatter = $formatter;
    }

    /**
     * The report query.
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function query()
    {
        return QueryPermissionFilters::for('core.report.browse')->apply(Report::query());
    }

    /**
     * The columns to show.
     *
     * @return array
     */
    public function columns()
    {
        return [
            'action' => [
                'title' => 'Actions',
                'name' => 'actions',
                'searchable' => false,
                'orderable' => false,
                'exportable' => false,
                'printable' => false,
            ],
            'name' => [
                'title' => 'Name',
                'name' => 'name',
                'searchable' => true,
                'orderable' => true,
                'exportable' => true,
                'printable' => true,
            ],
            'status' => [
                'title' => 'Status',
                'name' => 'status',
                'searchable' => true,
                'orderable' => true,
                'exportable' => true,
                'printable' => true,
            ],
            'sensitive' => [
                'name' => 'sensitive',
                'title' => 'Contains Sensitive Data',
                'searchable' => true,
                'orderable' => true,
                'exportable' => true,
                'printable' => true,
            ],
        ];
    }

    /**
     * Get a map of column keys => functions to format columns.
     *
     * @return array
     */
    protected function getColumnFormattingMap()
    {
        return [
            'action' => [$this->formatter, 'actions'],
            'status' => [$this->formatter, 'statusLabel'],
            'created_at' => [$this->formatter, 'createdAt'],
            'sensitive' => [$this->formatter, 'sensitive'],
        ];
    }

    /**
     * Get default builder parameters.
     *
     * @return array
     */
    protected function getBuilderParameters()
    {
        return parent::getBuilderParameters([
            'order' => [
                [1, 'asc'] // Name
            ],
        ]);
    }
}
