<?php

namespace Ignite\Core\Tests\Unit\Files\Processors;

use Ignite\Core\Files\Encryption\PGPFileEncrypter;
use Ignite\Core\Files\File;
use Ignite\Core\Files\Processors\EncryptFileProcessor;
use Ignite\Core\Files\TemporaryFile;
use Ignite\Core\Tests\TestCase;
use Illuminate\Support\Facades\Storage;

class EncryptFileProcessorTest extends TestCase
{
    /** @test */
    public function encrypts_files_to_a_temporary_location()
    {
        // Arrange
        Storage::fake();
        $file = File::new('SomeFile.txt');
        $file->put('some contents!!');

        // Execute
        $tempFile = (new EncryptFileProcessor('pgp'))->toTemporary()->run($file);

        // Check
        $this->assertInstanceOf(TemporaryFile::class, $tempFile);
        $this->assertEquals('some contents!!', $file->get());
        $this->assertEquals(
            'some contents!!',
            (new PGPFileEncrypter('pgp'))->decrypt($tempFile)->get()
        );
    }

    /** @test */
    public function encrypts_files_to_a_specified_location()
    {
        // Arrange
        Storage::fake();
        $file = File::new('SomeFile.txt');
        $file->put('some contents!!');

        // Execute
        $destinationFile = (new EncryptFileProcessor('pgp'))
            ->destination(File::new('Destination.txt.pgp'))
            ->run($file);

        // Check
        $this->assertTrue($destinationFile->is(File::new('Destination.txt.pgp')));
        $this->assertFalse($destinationFile->is($file));
        $this->assertEquals('some contents!!', $file->get());
        $this->assertEquals(
            'some contents!!',
            (new PGPFileEncrypter('pgp'))->decrypt($destinationFile)->get()
        );
    }
}
