<?php

namespace Ignite\Core\Validators;

use Illuminate\Contracts\Validation\Validator;

class EmailDomain
{
    /**
     * Validate an amount value.
     *
     * @param  string $attribute
     * @param  string $value
     * @param  array $parameters
     * @param  Validator $validator
     * @return bool
     * @throws \Exception
     */
    public function validate($attribute, $value, $parameters, $validator)
    {
        $value = trim($value);
        $domain = rtrim($parameters[0], '/') ?? '';

        if (empty($domain)) {
            throw new \Exception("Missing domain parameter for $attribute.");
        }

        return ends_with($value, $domain);
    }

    /**
     * Replace the domain key.
     *
     * @param  string $message
     * @param  string $attribute
     * @param  string $rule
     * @param  array $parameters
     * @return string
     */
    public function replaceDomain($message, $attribute, $rule, $parameters)
    {
        return str_replace(':domain', $parameters[0], $message);
    }
}
