<?php

namespace Ignite\Core\Models\Seeds;

use Ignite\Core\Entities\Block;

class CmsBlocksSeeder extends BaseSeeder
{
    /** @var string */
    protected $json = 'cms_blocks';

    /**
     * Seed the database table.
     *
     * @throws \Exception
     */
    public function seed()
    {
        $blocks = $this->parser->parse($this->path());

        foreach ($blocks as $block) {
            $this->seedBlock($block);
        }
    }

    /**
     * Remove pages from CMS.
     *
     * @param  array $blocks
     * @return bool
     */
    public function remove($blocks)
    {
        return Block::whereIn('code', $blocks)->delete();
    }

    /**
     * Seed a table record.
     *
     * @param  array $block
     * @return Page
     */
    private function seedBlock($block)
    {
        return Block::updateOrCreate(['code' => $block['code']], $block);
    }
}
