<?php

namespace Ignite\Core\Models;

use HTMLPurifier;
use HTMLPurifier_Config;

class Purifier
{
    /**
     * Clean the provided html and return.
     *
     * @param  string $html
     * @return string
     */
    public function clean($html)
    {
        $config = HTMLPurifier_Config::createDefault();

        $config->loadArray(config('core.html.options', []));

        $def = $config->getHTMLDefinition(true);

        $def->addAttribute('a', 'target', 'Enum#_blank,_self,_target,_top');

        $purifier = new HTMLPurifier($config);

        return $purifier->purify($html);
    }
}
