<?php

namespace Ignite\Core\Models\Grid;

use Ignite\Core\Models\Grid\TransactionFormatter;
use Illuminate\Support\HtmlString;

class WaitingTransactionsFormatter extends TransactionFormatter
{
    /**
     * Format a checkbox for selecting entries in the grid.
     *
     * @param object $model
     * @return HtmlString
     */
    public function checkbox($model): HtmlString
    {
        return $this->formatCheckbox($model->id);
    }

    /**
     * The balance of transactions for the user.
     *
     * @param object $model
     * @return string
     */
    public function actions(object $model): string
    {
        $actions = [];

        if (auth()->user()->can('core.transactions.waiting.assign')) {
            $actions[] = [
                'link' => route('admin.transactions.resource.edit', ['id' => $model->id]),
                'label' => 'Assign to Participant',
                'icon' => 'exchange'
            ];
        }

        return $this->html($this->buttons($actions));
    }
}
