<?php

namespace Ignite\Core\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CreatePageRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'label' => 'required|max:255',
            'locale' => 'size:5|regex:/([a-z]){2}_([A-Z]){2}/',
            'code' => 'required|regex:/([a-z0-9\-\/])/',
            'content' => 'required',
            'display_in_menu' => 'required|in:1,0',
            'is_protected' => 'in:1,0',
            'allowed_groups' => 'exists:core_group,id',
            'status' => 'required|in:active,inactive',
            'template' => 'required',
            'published_at' => 'required|date_format:Y-m-d H:i:s',
            'meta_title' => 'max:255',
            'meta_description' => 'max:255',
            'meta_keywords' => 'max:255',
        ];
    }

    /**
     * Get the error messages for the defined validation rules.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'code.unique' => sprintf('The URL code `%s` has already been used.', $this->code),
        ];
    }

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return $this->user()->can('core.cms.pages.create');
    }
}
