<?php

namespace Ignite\Core\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use Ignite\Core\Contracts\Repositories\ImportRepository;

class CreateImportRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @param ImportRepository $importRepository
     *
     * @return array
     */
    public function rules(ImportRepository $importRepository)
    {
        $types = $importRepository->getAllowedTypes();

        return [
            'file' => 'required|file',
            'type' => ['required',
                Rule::in(array_keys($types)),
            ],
        ];
    }

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }
}
