<?php

namespace Ignite\Core\Http\Controllers;

use Ignite\Core\Repositories\TransactionRepository;
use Illuminate\Support\Facades\View;

class TransactionController extends Controller
{
    /** @var TransactionRepository */
    protected $transactionRepository;

    /**
     * Create a new controller instance.
     *
     * @param TransactionRepository $transactionRepository
     */
    public function __construct(TransactionRepository $transactionRepository)
    {
        $this->transactionRepository = $transactionRepository;
    }

    /**
     * Show the Transactions for the given participant.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function index()
    {
        $transactions = $this->transactionRepository->findAuthenticated();

        return View::make('transaction.index', compact('transactions'));
    }
}
